#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
using NinjaTrader.NinjaScript.Indicators.Porschay;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.Porschay
{
	
	public enum PriscillianFilter2MTFTypeEnum
	{
		Second,
		Minute,
		Range,
		PorschayRXBars,
		TXRBars,
		QAI,
	}
	
	public class PriscillianFilter2MTF : Indicator
	{
		private NinjaTrader.NinjaScript.Indicators.PriscillianFilter2 engine6;
		
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Enter the description for your new custom Indicator here.";
				Name										= "Priscillian Engine MTF - 6";
				Calculate									= Calculate.OnBarClose;
				IsOverlay									= true;
				DisplayInDataBox							= true;
				DrawOnPricePanel							= true;
				DrawHorizontalGridLines						= true;
				DrawVerticalGridLines						= true;
				PaintPriceMarkers							= true;
				ScaleJustification							= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				ShowTransparentPlotsInDataBox				= true;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive					= true;
				
				barsType = NinjaTrader.NinjaScript.Indicators.Porschay.PriscillianFilter2MTFTypeEnum.Minute;
				value = 15;
				value2 = 15;
				baseBarsPeriodValue = 15;
				
				Poles	= 3;
				Period	= 20;
				
				AddPlot(Brushes.White, "SuperSmoother");
				AddPlot(Brushes.Transparent, "Trend");
				
			}
			else if (State == State.Configure)
			{
				#region MTF
				switch (barsType) {
					case PriscillianFilter2MTFTypeEnum.TXRBars:
						AddDataSeries(Data.BarsPeriodType.Tick, value);
						break;
					
					case PriscillianFilter2MTFTypeEnum.Second:
						AddDataSeries(Data.BarsPeriodType.Second, value);
						break;
					
					case PriscillianFilter2MTFTypeEnum.Minute:
						AddDataSeries(Data.BarsPeriodType.Minute, value);
						break;
						
					case PriscillianFilter2MTFTypeEnum.Range:
						AddDataSeries(Data.BarsPeriodType.Range, value);
						break;
					
					case PriscillianFilter2MTFTypeEnum.PorschayRXBars:
						AddDataSeries(new BarsPeriod { BarsPeriodType = (BarsPeriodType)2019, Value = value, Value2 = value2 });
						break;
					
					case PriscillianFilter2MTFTypeEnum.QAI:
						AddDataSeries(new BarsPeriod { BarsPeriodType = (BarsPeriodType)230507, BaseBarsPeriodValue = baseBarsPeriodValue, Value = value, Value2 = value2 });
						break;
				}
				#endregion
			}
			else if (State == State.DataLoaded)
			{
				engine6 = PriscillianFilter2(BarsArray[1], Poles, Period);
			}
		}

		protected override void OnBarUpdate()
		{
			if(CurrentBars[1] < Period)
				return;
			
			Values[0][0] = engine6.Values[0][0];
			Values[1][0] = engine6.Values[1][0];
			
			PlotBrushes[0][0] = engine6.Values[1][0] == 1 ? Brushes.Lime : Brushes.Red;
		}
		
		#region Properties
		[NinjaScriptProperty]
        [Display(Name = "# Poles", Description = "Number of Poles", Order = 0, GroupName = "Gen. Parameters")]
        public int Poles
        { get;set; }

        [NinjaScriptProperty]
        [Display(Name = "Period", Description = "Period", Order = 1, GroupName = "Gen. Parameters")]
        public int Period
        { get;set; }
		
		[NinjaScriptProperty]
		[Display(Name="Bars Type", Order=1, GroupName="Parameters")]
		public NinjaTrader.NinjaScript.Indicators.Porschay.PriscillianFilter2MTFTypeEnum barsType { get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Value", Order=2, GroupName="Parameters")]
		public int value
		{ get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Value2", Order=3, GroupName="Parameters")]
		public int value2
		{ get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Q.AI (Open Offset)", Order=4, GroupName="Parameters")]
		public int baseBarsPeriodValue
		{ get; set; }
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private Porschay.PriscillianFilter2MTF[] cachePriscillianFilter2MTF;
		public Porschay.PriscillianFilter2MTF PriscillianFilter2MTF(int poles, int period, NinjaTrader.NinjaScript.Indicators.Porschay.PriscillianFilter2MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue)
		{
			return PriscillianFilter2MTF(Input, poles, period, barsType, value, value2, baseBarsPeriodValue);
		}

		public Porschay.PriscillianFilter2MTF PriscillianFilter2MTF(ISeries<double> input, int poles, int period, NinjaTrader.NinjaScript.Indicators.Porschay.PriscillianFilter2MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue)
		{
			if (cachePriscillianFilter2MTF != null)
				for (int idx = 0; idx < cachePriscillianFilter2MTF.Length; idx++)
					if (cachePriscillianFilter2MTF[idx] != null && cachePriscillianFilter2MTF[idx].Poles == poles && cachePriscillianFilter2MTF[idx].Period == period && cachePriscillianFilter2MTF[idx].barsType == barsType && cachePriscillianFilter2MTF[idx].value == value && cachePriscillianFilter2MTF[idx].value2 == value2 && cachePriscillianFilter2MTF[idx].baseBarsPeriodValue == baseBarsPeriodValue && cachePriscillianFilter2MTF[idx].EqualsInput(input))
						return cachePriscillianFilter2MTF[idx];
			return CacheIndicator<Porschay.PriscillianFilter2MTF>(new Porschay.PriscillianFilter2MTF(){ Poles = poles, Period = period, barsType = barsType, value = value, value2 = value2, baseBarsPeriodValue = baseBarsPeriodValue }, input, ref cachePriscillianFilter2MTF);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.Porschay.PriscillianFilter2MTF PriscillianFilter2MTF(int poles, int period, NinjaTrader.NinjaScript.Indicators.Porschay.PriscillianFilter2MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue)
		{
			return indicator.PriscillianFilter2MTF(Input, poles, period, barsType, value, value2, baseBarsPeriodValue);
		}

		public Indicators.Porschay.PriscillianFilter2MTF PriscillianFilter2MTF(ISeries<double> input , int poles, int period, NinjaTrader.NinjaScript.Indicators.Porschay.PriscillianFilter2MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue)
		{
			return indicator.PriscillianFilter2MTF(input, poles, period, barsType, value, value2, baseBarsPeriodValue);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.Porschay.PriscillianFilter2MTF PriscillianFilter2MTF(int poles, int period, NinjaTrader.NinjaScript.Indicators.Porschay.PriscillianFilter2MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue)
		{
			return indicator.PriscillianFilter2MTF(Input, poles, period, barsType, value, value2, baseBarsPeriodValue);
		}

		public Indicators.Porschay.PriscillianFilter2MTF PriscillianFilter2MTF(ISeries<double> input , int poles, int period, NinjaTrader.NinjaScript.Indicators.Porschay.PriscillianFilter2MTFTypeEnum barsType, int value, int value2, int baseBarsPeriodValue)
		{
			return indicator.PriscillianFilter2MTF(input, poles, period, barsType, value, value2, baseBarsPeriodValue);
		}
	}
}

#endregion
